using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Int32eropServices;


namespace DEMO
{
    class adt8948A1m
    {
        //----------------------------------------------------//
        //                  Basic parameters settings         //
        //----------------------------------------------------//

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_initial();
        /***************************Initialize motion card*******************************
        Function:Initialize motion card
        (1)Return>0,Return value is the quantity of ADT-8948 cards in the system. Value 3 indiates that three cards have been installed and available card numbers are 0, 1 and 2;
        (2)Return,Value 0 indicates that no ADT-8948A1 card has been installed
        (3)Return<0,Value -1 indicates that the drivers of ADT-8948A1 card havent been installed
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_end();
        /******************************release ADT8948A1 card******************************
        Function:Release the resources of motion card
        Return	   0:correct			1:wrong
        This function contains the library function that releases the control card; it should be invoked at the end of the program,(only in Windows NT/2000).
        release of ADT8948 source occupied
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_triangle_prevent(Int32 cardno,Int32 value); 
        /*****************************Set triangle wave form prevent function*****************************
        Function: set up if enabled triangle waveform prevent function
        Cardno card number
        Value 0: disabled 1: opening
        Returns 0: correct 1: errors
        The default mode: enable triangle waveform prevent function
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_stop0_mode(Int32 cardno, Int32 axis, Int32 value, Int32 logic);
        /*********************Set mode of stop0 input signal**********************
        Function:Set the valid/invalid and logical electricity of stop0 signal 
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   0:invalid		1:valid
	        logic	   0:low level stop	1:high level stop
        Return	        0:correct			1:wrong
        Default modes:invalidlow level stop
        ******************************************************************/

       [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_stop1_mode(Int32 cardno, Int32 axis, Int32 value, Int32 logic);
        /*********************Set mode of stop1 input signal**********************
        Function:Set the valid/invalid and logical electricity of stop1 signal
        Parameter:
	        cardno	    card number
	        axis	    axis number(1-4)
	        value	    0:invalid		1:valid
	        logic	    0:low level stop	1:high level stop
        Return	        0:correct			1:wrong
        Default modes:invalidlow level stop
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_stop2_mode(Int32 cardno, Int32 axis, Int32 value, Int32 logic);
        /*********************Set mode of stop2 input signal**********************
        Function:Set the valid/invalid and logical electricity of stop2 signal
        Parameter:
	        cardno	    card number
	        axis	    axis number(1-4)
	        value	    0:invalid		1:valid
	        logic	    0:low level stop	1:high level stop
        Return		0:correct			1:wrong
        Default modes:invalidlow level stop
        STOP2 signal can clear actual position counter when it is valid.
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_actualcount_mode(Int32 cardno, Int32 axis, Int32 value, Int32 dir, Int32 freq);
        /**********************set the working mode of actual position counter********************
        Function:Set the working mode of actual position counter
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   Pulse input mode
			        0:A/B pulse input	1:Up/Down (PPIN/PMIN) pulse input
	        dir	   Counting direction
	        0:	A leads B or PPIN pulse input up count			
                        B leads A or PMIN pulse input down count
	        1:      B leads A or PMIN pulse input up count			
                        A leads B or PPIN pulse input down count
	        freq	Frequency multiplication of A/B pulse input,Invalid for Up/Down pulse input
		        0: 4     1: 2        2: 1
        Return	   0:correct			1:wrong
        Default modes: A/B pulse inputdirection: 0Frequency multiplication: 4
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_pulse_mode(Int32 cardno,Int32 axis,Int32 value,Int32 logic,Int32 dir_logic);
        /**********************Set working mode of output pulse**********************
        Function:Set working mode of output pulse
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value 	   0: Pulse+Pulse     1:Pulse+Direction
	        logic	   0:Positive logical pulse		 1:Negative logical pulse
	        dir-logic  0:Positive logic of direction output signal 
                           1:Negativelogic of direction output signal
        Return	       0:correct				 1:wrong
        Default modes:Pulse + direction,positive logical pulse,Positive logic of direction output signal.
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_limit_mode(Int32 cardno,Int32 axis,Int32 value,Int32 logic);
        /**************Set the mode of positive/negative limit input signal nLMT*************
        Function:Set the mode of positive/negative limit input signal nLMT
        Parameter:
	        cardno	        card number
	        axis		axis number(1-4)
	        value		0:sudden stop	1:decelerated stop
	        logic		0:low level valid		1:high level valid
        Return	        0:correct				1:wrong
        Default modes:sudden stoplow level valid
        Notice:The limit signal cant be valid or invalid.
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_softlimit_mode1(Int32 cardno,Int32 axis,Int32 value);
        /*******************Setting of COMP+ register as software limit********************
        Function:Setting of COMP+ register as software limit
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   0:invalid				1:valid
        Return		   0:correct				1:wrong
        Default modes: invalid
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_softlimit_mode2(Int32 cardno,Int32 axis,Int32 value);
        /*******************Setting of COMP- register as software limit********************
        Function:Setting of COMP- register as software limit
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   0:invalid				1:valid
        Return		   0:correct				1:wrong
        Default modes: invalid
        ******************************************************************/


        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_softlimit_mode3(Int32 cardno,Int32 axis,Int32 value);
        /*******************Comparison objects setting of COMP+/- registers********************
        Function:Comparison objects setting of COMP+/- registers
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   0:Logical position counter	1:Actual position counter
        Return		   0:correct				1:wrong
        Default modes:Logical position counter
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_out(Int32 cardno,Int32 number);
        /******************Get the status of output****************
        Date:080222
        Parameter:
	        cardno       card number
	        number       port number
        Return:current status of appoInt32ed port,-1 indicates that parameter wrong    
        ***********************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_disable_soft_limit(Int32 cardno,Int32 axis);
        /***************************Disable software limit***************************
        Function:Disable software limit
        Parameter:
	        cardno       card number
	        axis         axis number
        Return         0:correct                 1:wrong  
        *******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_enable_soft_limit(Int32 cardno,Int32 axis, Int32 value);
        /****************************Enable software limit**************************
        Function:Enable software limit
        Parameter:
	        cardno       card number
	        axis         axis number
	        value        compare objects (0:Logical counter,1:Actual position counter)
        Return       0:correct                 1:wrong  
        *******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_inpos_mode(Int32 cardno,Int32 axis,Int32 value,Int32 logic);
        /**********************Setting of servo in-position signal nINPOS********************
        Function:Set the working mode of servo in-position signal nINPOS
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   0:invalid			1:valid
	        logic	   0:low level valid		1:high level valid
        Return		   0:correct			1:wrong
        Default modes : invalidlow level valid
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_alarm_mode(Int32 cardno,Int32 axis,Int32 value,Int32 logic);
        /*********************Setting of servo alarm signal nALARM*********************
        Function:Set the working mode of servo alarm signal nALARM
        Parameter:
	        cardno	        card number
	        axis		axis number(1-4)
	        value		0:invalid				1:valid
	        logic		0:low level valid			1:high level valid
        Return			0:correct				1:wrong
        Default modes : invalidlow level valid
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_ad_mode(Int32 cardno,Int32 axis,Int32 value);
        /***********************Acceleration/deceleration setting**************************
        Function:Select linear or S-curve acceleration/deceleration.
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   0:linear A/D		1:S-curve A/D
        Return		   0:correct		1:wrong
        Default modes : linear acceleration/deceleration
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_dec1_mode(Int32 cardno,Int32 axis,Int32 value);
        /*****************Asymmetric ladder acceleration/deceleration setting*******************
        Function:Select symmetric or asymmetric acceleration/deceleration.
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   use in deceleration
			        0:value of acceleration(symmetric)
			        1:value of acceleration(asymmetric)
        Return			0:correct				  1:wrong
        Default modes : symmetric acceleration/deceleration
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_dec2_mode(Int32 cardno,Int32 axis,Int32 value);
        /*****Deceleration mode setting of acceleration/deceleration quantitative driving*********
        Function:Set deceleration mode
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   0:Automatic deceleration			1:manual deceleration              
        Return	       0:correct					1:wrong
        Default modes : Automatic deceleration 
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_circle_mode(Int32 cardno,Int32 axis,Int32 value);
        /*******************Setting of variable circle function of the counter*****************
        Function:Set the variable circle mode of counter
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value 	   0:invalid					1:valid
        Return		   0:correct					1:wrong
        Default modes : invalid
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_input_filter(Int32 cardno,Int32 axis,Int32 number,Int32 value);
        /************************Input signal filtering function setting**********************
        Function:Set the filtering function of input signal
        Parameter:
	        cardno	    card number
	        axis	    axis number(1-4)
	        number	    Input types
				        1:LMT+LMT-STOP0STOP1
				        2:STOP2
				        3:nINPOSnALARM
				        4:nIN
				        Set the filtering state of the four types input signals above
	        value		0:Filtering invalid        1: Filtering valid
        Return          0:correct          1:wrong
        Default modes : invalid
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_filter_time(Int32 cardno,Int32 axis,Int32 value);
        /*********************Constant setting of filtering time of input signals*******************
        Function:Set the filtering time constant of input signals
        Parameter:
	        cardno	    card number
	        axis	    axis number(1-4)
	        value	    Maximum noise amplitude reduced(range)   Input signal delay(range)
        Return         0:correct          1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_lock_position(Int32 cardno, Int32 axis,Int32 regi,Int32 logical);
        /****************************Set the working mode of position lock**********************
        Function:Set the working mode of position lock,Lock the logical position and actual position of all axis
        Parameter:
	        axisReference axis
	        regiCounter mode  |0:logical counter
			            |1:actual counter 
	        logicalLevel signal |0:From high to low
			              |1: From low to high
        Return         0:correct          1:wrong
	        Note:Use IN signal of specific axis as the trigger signal				
        *******************************************************************/

        //----------------------------------------------------//
        //                  Driving status checking           //
        //----------------------------------------------------//

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_status(Int32 cardno,Int32 axis,out Int32 value);
        /*************************Get the driving status of single axis***********************
        Function:Get the driving status of single axis
        Parameter:
	        cardno	        card number
	        axis		axis number(1-4)
	        value		Index of driving status
				        0:Driving stopped       Non-0: the value is in 2 bytes
        Return	    0:correct					1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_stopdata(Int32 cardno,Int32 axis,out Int32 value);
        /*************************Get the error stop data of axes*******************
        Function:Get the error stop data of axes
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   Index of error status
	 	           0:No error         Non-0:the value is in 2 bytes 
        Return         0:correct          1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_inp_status(Int32 cardno,out Int32 value);
        /************************Get the driving status of Int32erpolation************************
        Function:Get the driving status of Int32erpolation
        Parameter:
	        cardno	    card number
	        value	    Index of Int32erpolation status
		            0: Int32erpolation stopped	1: Int32erpolating
        Return	    0:correct			 1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_inp_status2(Int32 cardno,out Int32 value);
        /***************Get the writable status of continuous Int32erpolation******************
        Function:Get the writable status of continuous Int32erpolation
        Parameter:
	        cardno	   card number
	        value	   Index of writing status
			        0: Unwritable	   1: Writable
        Return	   0:correct				    	1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_lock_status(Int32 cardno, Int32 axis, out Int32 status);
        /*************************Get lock status***********************
        Function:Get the status of position lock
        Parameter:
	        cardno       card number
	        axis         axis number
	        status       Lock status (0: unlocked, 1: locked)
        Return         0:correct          1:wrong
        Note:This function could tell whether the position lock has been executed		
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_home_status(Int32 cardno, Int32 axis, out Int32 status, out Int32 err);
        /**************************Get back-to-home status************************
        Function:Get back-to-home status
        Parameter:
	        cardno      card number
	        axis        axis number
                status      Whether driving is stopped (0: stopped, 1: moving)
	        err         Whether error occurs (0:Normal, 1: Error)
        Return         0:correct          1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_home_error(Int32 cardno, Int32 axis ,out Int32 err);
        /************************Get back-to-home error************************
        Function:Get back-to-home error   
        Parameter:	        
              errError marker
			        0: Normal     >0: Error
                                D0: comp+ limit
                                D1: comp- limit
                                D2: LMT+ limit
                                D3: LMT- limit
                                D4: Servo alarm
                                D5: Emergency stop
                                D6: Z phase signal arrives in advance
        Return         0:correct          1:wrong
        ******************************************************************/

        //----------------------------------------------------//
        //               Moving parameter settings            //
        //----------------------------------------------------//
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_range(Int32 cardno, Int32 axis,Int32  Value);
        /*****************************Range setting*****************************
        Function:Range setting
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   R-value range(8000000-16000)
        Return	   0:correct				1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_acac(Int32 cardno, Int32 axis,Int32  Value);
        /******************Set the change rate of acceleration/deceleration*********************
        Function:Set the change rate of acceleration/deceleration
        Parameter:
	        cardno	    card number
	        axis	    axis number (1-4)
	        value	    K-value range(1-65535)
        Return	   0:correct				1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_acc(Int32 cardno, Int32 axis,Int32  Value);
        /****************************Acceleration setting****************************
        Function:Set the value of acceleration
        Parameter:
	        cardno	    card number
	        axis	    axis number(1-4)
	        value	    A-value range(1-8000)
        Return	    0:correct				1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_dec(Int32 cardno, Int32 axis,Int32  Value);
        /*****************************Deceleration setting***************************
        Function:Set the value of deceleration
        Parameter:
	        cardno	    card number
	        axis	    axis number(1-4)
	        value	    D-value(1-8000)
        Return	    0:correct				1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_startv(Int32 cardno, Int32 axis,Int32  Value);
        /****************************Start velocity setting**************************
        Function:Set the value of start velocity
        Parameter:
	        cardno	    card number
	        axis	    axis number(1-4)
	        value       SV-value(1-8000)
        Return	    0:correct				1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_speed(Int32 cardno, Int32 axis,Int32  Value);
        /****************************Driving speed setting**************************
        Function:Set the value of driving speed
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   V-value(1-8000)
        Return	   0:correct				1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_command_pos(Int32 cardno, Int32 axis,Int32  Value);
        /**************************Logical position counter setting**********************
        Function:Set the value of logical position counter
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   range(-2147483648~+2147483647)
        Return	   0:correct				1:wrong
        Notice:You can access the logical position counter in real time
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_actual_pos(Int32 cardno, Int32 axis,Int32  Value);
        /**************************Actual position counter setting**********************
        Function:Set the value of actual position counter
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   range(-2147483648~+2147483647)
        Return	   0:correct				1:wrong
        Notice:You can access the actual position counter in real time
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_comp1(Int32 cardno, Int32 axis,Int32  Value);
        /**************************COMP+ register setting*************************
        Function:COMP+ register setting
        Parameter:
	        cardno	    card number
	        axis	    axis number(1-4)
	        value       range(-2147483648~+2147483647)
        Return	   0:correct				1:wrong
        Notice:You can access the COMP+ register in real time
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_comp2(Int32 cardno, Int32 axis,Int32  Value);
        /*************************COMP- register setting**************************
        Function:COMP- register setting
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   range(-2147483648~+2147483647)
        Return	   0:correct				1:wrong
        Notice:You can access the COMP- register in real time
        ******************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_soft_limit(Int32 cardno, Int32 axis, Int32  value1, Int32  value2);
        /**************************Software limit setting************************
        Function:Set the value of software limit
        Parameter:
	        cardno       card number
	        axis         axis number
	        value1       positive limit 
                value2       negative limit 
        Return      0:correct              1:wrong  
        *******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_dec_pos(Int32 cardno, Int32 axis,Int32  Value);
        /***************************Set manual deceleration position*************************
        Function:Set the value of COMP+ register
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        value	   range(0~268435455)
        Return	   0:correct				1:wrong
        If manual deceleration mode is used, you need to set manual deceleration poInt32 first
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_vector_speed(Int32 cardno, Int32 mode);
        /************************Set constant linear speed mode************************
        Function:Set constant linear speed mode
        Parameter:
	        cardno card number   
	        mode0|do not use constant linear speed
	              1| use constant linear speed
        Return         0:correct          1:wrong
        Notice:Linear speed indicates vector speed. Constant linear speed can guarantee the constant combination speed in Int32erpolation
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_home_mode(Int32 cardno, Int32 axis,Int32  speed,Int32 logical0, Int32 logical1, Int32 logical2,Int32 offset,Int32 dir0, Int32 dir1, Int32 dir2,Int32 offsetdir,Int32 clear,Int32  pulse);
        /******************************Set back-to-home mode************************
        Function:Set back-to-home mode of appoInt32ed axis
        Parameter:
	           logical0stop0|0:low level stop
					          |1:high level stop
					          |-1:invalid
	           logical1stop1|0:low level stop
					          |1:high level stop
					          |-1:invalid	
	           logical2stop2|0:low level stop
					          |1:high level stop
					          |-1:invalid	   
                   0ffset 0|do not offset from home
	                    1|offset from home
	           dir0direction|0:positive
	                          |1:negative
	           dir1direction|0:positive
	                          |1:negative
	           dir2direction|0:positive
	                          |1:negative	   
	           offsetdirOffset direction|0:positive
	                                      |1:negative			 
	           speedLow speed research(this value should be lower than start velocity of high speed)
	           clearClear counter? (0: Yes, 1: No)
        Return         0:correct          1:wrong
        Note:
		        (1)Back-to-home by 4 step:
		           |step1:hiah-speed near home search stop0((logical0 close home setup);
		           |step2:low-speed home search stop1(logical1 home setup);
		           |step3:low-speed Z-phase search stop2(logical2 encoder Z-phase);
		           |step4:high-speed offset drive(For working origin);
                        (2) The above four steps can decide whether to be carried out by choosing among logical0, logical1logical2 and offset
		        (3)Able to use a proximity switch to act as several signals
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_symmetry_speed(Int32 cardno,Int32 axis,Int32  lspd,Int32  hspd,double tacc,Int32  vacc,Int32 mode);
        /**************************Set symmetric acceleration/deceleration************************
        Function:Set the value of symmetric acceleration/deceleration
        Parameter:
	        cardno       card number
	        axis         axis number
	        lspd         start speed
                hspd         driving speed
	        tacc         acceleration time
	        vacc         acceleration change rate
	        mode         acceleration mode (0:ladder 1:S-curve)
        Return           0:correct          1:wrong  
        ******************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_unsymmetry_speed(Int32 cardno,Int32 axis,Int32  lspd,Int32  hspd,double tacc,double tdec,Int32  vacc,Int32 mode);
        /************************Set asymmetric acceleration/deceleration***********************
        Function:Set the value of asymmetric acceleration/deceleration
        Parameter:
	        cardno       card number
	        axis         axis number
	        lspd         start speed
                hspd         driving speed
	        tacc         acceleration time
	        tdec         deceleration time
	        vacc         acceleration change rate
	        mode         acceleration mode (0:ladder 1:S-curve)
        Return           0:correct          1:wrong  
        ******************************************************************/

        //----------------------------------------------------//
        //                Moving parameter checking           //
        //----------------------------------------------------//

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_command_pos(Int32 cardno,Int32 axis,out Int32 pos);
        /***********************Get the logical position of axes***********************
        Function:Get the logical position of axes
        Parameter:
	        cardno	        card number
	        axis		axis number(1-4)
	        pos		Index of logical position value
        Return	   0:correct			1:wrong
        Notice:You can use this function to get the logical position of axes and it can represent the current position of axes if the motor is not out of step
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_actual_pos(Int32 cardno,Int32 axis,out Int32 pos);
        /************************Get the actual position of axis************************
        Function:Get the actual position of axis
        Parameter:
	        cardno	        card number
	        axis		axis number(1-4)
	        pos		Index of actual position value
        Return		0:correct		1:wrong
        Notice:You can use this function to get the actual position of axes and you can get the current position of axes even if the motor is out of step
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_speed(Int32 cardno,Int32 axis,out Int32 pos);
        /*******************Get the current driving speed of axes*******************
        Function:Get the current driving speed of axes
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        speed	   Index of current driving speed
        Return		0:correct		1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_ad(Int32 cardno,Int32 axis,out Int32 pos);
        /**************************Get the current acceleration of axes********************
        Function:Get the current acceleration of axes
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
	        ad	   Index of current acceleration
        Return		0:correct		1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_lock_position(Int32 cardno,Int32 axis,out Int32 pos);
        /**************************Get lock position**************************
        Function:Get lock position
        Parameter:
	        cardno      card number
	        axis        axis number
	        pos         Locked position
        Return         0:correct          1:wrong
        ******************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_get_lib_vision(out Int32 ver);
        /************************Library function version checking**************************
        *Function:Get the version of library function
        *Parameter:
              Version number index (ver is a 4-digit Int32eger with the first two digits are master version number and last two sigits are secondary version number)
        Return         0:correct          1:wrong
        ******************************************************************/

        //----------------------------------------------------//
        //                     Basic driving                  //
        //----------------------------------------------------//
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_pmove(Int32 cardno,Int32 axis,Int32  pulse);
        /*****************************Quantitative driving*****************************
        Function:Single axis quantitative driving
        Parameter:
	        cardno 	   card number
	        axis	   axis number(1-4)
	        pulse 	   output pulses         range(-268435455~+268435455)
		           >0: Positive		 <0: Negative
        Return	   0:correct				    1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_continue_move(Int32 cardno,Int32 axis,Int32 dir);
        /*****************************Continuous driving*****************************
        Function:Single axis continuous driving
        Parameter:
	        cardno 	   card number
	        axis	   axis number(1-4)
	        dir	   driving direction   0: Positive	 1: Negative
        Return	      0:correct			   1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_dec_stop(Int32 cardno,Int32 axis);
        /*****************************Decelerated stop*************************
        Function:Stop current driving process in deceleration
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
        Return	   0:correct			1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_sudden_stop(Int32 cardno,Int32 axis);
        /******************************Sudden stop************************
        Function:Stop current driving process immediately
        Parameter:
	        cardno	   card number
	        axis	   axis number(1-4)
        Return	   0:correct			1:wrong
        Notice:Stop pulse output immediately in acceleration/deceleration and constant speed driving process.
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_stop_axis(Int32 cardno,Int32 axis,Int32 mode);
        /*****************************Stop single axis*****************************
        Function:Stop the moving of singl axis in set mode.
        Parameter:
	        cardno       card number
	        axis         axis number 
	        mode         stop mode(0:sudden stop 1:decelerated stop)
        Return           0:correct          1:wrong  
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_stop_all(Int32 cardno,Int32 mode);
        /*****************************Stop all axes**************************
        Function:Stop the moving of all axes of appoInt32ed card in set mode.
        Parameter:
	        cardno       card number	
	        mode         stop mode(0:sudden stop 1:decelerated stop)
        Return           0:correct          1:wrong  
        ******************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_move2(Int32 cardno,Int32 axis1,Int32 axis2,Int32  pulse1,Int32  pulse2);
        /***************************Two axes linear Int32erpolation***************************
        Function:Two axes linear Int32erpolation
        Parameter:
	        cardno	   card number
	        axis1,axis2     Int32erpolation axis number         1:X    2:Y  3:Z  4:W
	        pulse1,pulse2	Moving relative distance of axis1,axis2   range(-8388608~+8388607)
        Return	   0:correct			  	  1:wrong
        Notice:The Int32erpolation speed takes the speed of the axis with smaller axis number between axis1 and axis2 as the standard
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_cw_arc(Int32 cardno,Int32 axis1,Int32 axis2, Int32  x,Int32  y,Int32  i,Int32  j);
        /*************************CW arc Int32erpolation*************************
        Function:Two axes CW arc Int32erpolation
        Parameter:
	        cardno	           card number
	        axis1,axis2	   Int32erpolation axis number         1:X    2:Y  3:Z  4:W
	        x,y		   End poInt32 position of arc Int32erpolation (relative to start poInt32) 	   range(-8388608~+8388607)
	        i,j	     Circle center position of arc Int32erpolation (relative to start poInt32)             range(-8388608~+8388607)
        Return	   0:correct		 		  1:wrong
        Notice:The Int32erpolation speed takes the speed of axis1
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_ccw_arc(Int32 cardno,Int32 axis1,Int32 axis2,Int32  x,Int32  y,Int32  i,Int32  j);
        /***************************CCW arc Int32erpolation**********************
        Function:Two axes CCW arc Int32erpolation
        Parameter:
	        cardno	         card number
	        axis1,axis2	 Int32erpolation axis number      1:X    2:Y  3:Z  4:W
	        x,y		 End poInt32 position of arc Int32erpolation (relative to start poInt32) 	   range(-8388608~+8388607)
	        i,j	       Circle center position of arc Int32erpolation (relative to start poInt32)            range(-8388608~+8388607)
        Return	   0:correct				  1:wrong
        Notice:The Int32erpolation speed takes the speed of axis1
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_move3(Int32 cardno,Int32 axis1,Int32 axis2, Int32 axis3,Int32  pulse1,Int32  pulse2,Int32  pulse3);
        /***********************Three axes linear Int32erpolation*************************
        Function:Three axes linear Int32erpolation
        Parameter:
	        cardno 	                card number
	        axis1,axis2,axis3	Int32erpolation axis number     1:X    2:Y  3:Z  4:W
	        pulse1,pulse2,pulse3	Moving relative distance of X-Y-Z axis  
                                        range (-8388608~+8388607)  
	        Three axes Int32erpolation,only X-Y-Z axis Int32erpolation
        Return	   0:correct				  1:wrong
        Notice:The Int32erpolation speed takes the speed of axis1
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_dec_enable(Int32 cardno);
        /****************************Enable Int32erpolation deceleration**********************
        Function:Enable deceleration of Int32erpolation
        Parameter:
	        cardno 	   card number
        Return         0:correct          1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_dec_disable(Int32 cardno);
        /****************************Disable Int32erpolation deceleration**************************
        Function:Disable deceleration of Int32erpolation
        Parameter:
	        cardno	   card number
        Return	    0:correct			 	     1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_manual_pmove(Int32 cardno, Int32 axis, Int32  pulse);
        /************************Manual quantitative driving**********************
        Function:Quantitative driving of external signals
        Parameter:
	        cardno      card number
	        axis        axis number
	        pulse       pulse
        Return         0:correct          1:wrong
        Note:(1) Send out fixed pulse, but the drive does not start immediately until the level of external signal changes
        (2) Ordinary button and handwheel are acceptable
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_manual_continue(Int32 cardno, Int32 axis);
        /************************Manual continuous driving**********************
        Function:Continuous driving of external signals
        Parameter:
	        cardno     card number
	        axis       axis number
        Return         0:correct          1:wrong
        Note: (1) Send out fixed pulse, but the drive does not start immediately until the level of external signal changes
        (2) Ordinary button and handwheel are acceptable

        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_manual_disable(Int32 cardno, Int32 axis);
        /***********************Disable manual driving***********************
        Function:Disable manual driving function
        Parameter:
	        cardno      card number
	        axis        axis number
        Return         0:correct          1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_step_command2(Int32 cardno,Int32 axis1,Int32 axis2,Int32  pulse1,Int32  pulse2);
        /*********************Command type two axes stepping Int32erpolation*********************	
        Function:Set the data of two axes command stepping Int32erpolation.
        Parameter:
	        the same as 2-axis Int32erpolation
        Return         0:correct          1:wrong
        Note:Send out data of stepping Int32erpolation, the drive does not start but waiting for drive command function
        ******************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_step_command3(Int32 cardno,Int32 axis1,Int32 axis2,Int32 axis3,Int32  pulse1,Int32  pulse2, Int32  pulse3);
        /********************Command type three axes stepping Int32erpolation*********************
        Function:Set the data of three axes command stepping Int32erpolation.
        Parameter:
	        the same as 3-axis Int32erpolation
        Return         0:correct          1:wrong
        Note:Send out data of stepping Int32erpolation, the drive does not start but waiting for drive command function
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_step_move(Int32 cardno);
        /***********************Command stepping Int32erpolation driving***********************
        Function:Execute command stepping Int32erpolation in single step
        Parameter:
	        cardno      card number
        Return         0:correct          1:wrong
        Note:Drive the stepping motion in the form of command according to the parameter of the set function
        ******************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_step_signal2(Int32 cardno,Int32 axis1,Int32 axis2,Int32  pulse1,Int32  pulse2);
        /*********************Signal type two axes stepping Int32erpolation**********************
        Function:Set the data of two axes signal type stepping Int32erpolation.
        Parameter:
	        the same as 2-axis Int32erpolation
        Return         0:correct          1:wrong
        Note:Send out data of stepping Int32erpolation, the drive does not work but waiting for the external signal level to drop to low level
        *******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_step_signal3(Int32 cardno,Int32 axis1,Int32 axis2,Int32 axis3,Int32  pulse1,Int32  pulse2, Int32  pulse3);
        /*********************Signal type three axes stepping Int32erpolation*********************
        Function:Set the data of three axes stepping Int32erpolation.
        Parameter:
	        the same as 3-axis Int32erpolation
        Return         0:correct          1:wrong
        Note:Send out data of stepping Int32erpolation, the drive does not work but waiting for the external signal level to drop to low level
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_inp_step_stop(Int32 cardno,Int32 axis);
        /*************************Stop stepping Int32erpolation*************************	
        Function:Stop executing stepping Int32erpolation.
        Parameter:
	        cardno      card number
	        axis        axis number
        Return         0:correct          1:wrong
        	
        Notice: Axis that is in the state of stepping Int32erpolation must carry out the stop command of stepping Int32erpolation before going to other drives
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_home(Int32 cardno,Int32 axis);
        /****************************Automatic back-to-home**************************
        Function:AppoInt32ed axis executes back-to-home motion automatically.
        Parameter:
	        cardno      card number
	        axis        axis number
        Return         0:correct          1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_clear_home_error(Int32 cardno, Int32 axis);
        /***************************Clear back-to-home error***********************
        Function:Clear back-to-home error
        Parameter:
	        cardno      card number
	        axis        axis number
        Return         0:correct          1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_in_move1(Int32 cardno,Int32 axis,Int32 axis1,Int32  pulse,Int32  pulse1,Int32 logical,Int32 mode);
        /*******************Signal type single axis follow moving setting*******************
        Function:setting synchronous move function
        Parameter:
		        axisActive axis
		        axis1Driven axis
		        pulseActive axis pulses
		        pulse1Driven axis1 pulses
		        logicalElectricity level logic|0:from high to low 
					                |1:from low to high				
		        modeRunning status of active axis0|persistent
						           1|appoInt32ed pulse
        Return         0:correct          1:wrong
        Note:Use the IN signal of active axis as trigger signal				  
        *******************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_in_move2(Int32 cardno, Int32 axis, Int32 axis1,Int32 axis2 ,Int32  pulse,Int32  pulse1,Int32  pulse2,Int32 logical,Int32 mode);
        /*******************Signal type 2 axes follow moving setting*************************
        Function: Set the IN synchronization action
        Parameter:
		        axisactive axis
		        axis1driven axis
		        axis2driven axis
		        pulse1pulse
		        pulse2pulse
		        logicalLevel signal|0:From high to low 
				             |1:From low to high					
		        modeThe active axis has moved? 0| Yes
						         1| No
        Return         0:correct          1:wrong
        Note:Use the IN signal of active axis as trigger signal 
        ********************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_in_move3(Int32 cardno, Int32 axis, Int32 axis1,Int32 axis2,Int32 axis3 ,Int32  pulse,Int32  pulse1,Int32  pulse2, Int32  pulse3,Int32 logical,Int32 mode);
        /*********************Signal type 3 axes follow moving setting*************************	
        Function:Set the IN synchronization action
        Parameter:
		        axisactive axis
		        axis1driven axis1
		        axis2driven axis2
		        axis3driven axis3
		        pulsedrive pulse of active axis
		        pulse1drive pulse of driven axis1
		        pulse2drive pulse of driven axis2
		        pulse3drive pulse of driven axis3
		        logicalLevel signal|0:From high to low 
				             |1:From low to high	
		        modeThe active axis has moved? 0| Yes
						         1| No
        Return         0:correct          1:wrong
        Note:Use the IN signal of active axis as trigger signal						**********************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_in_stop1(Int32 cardno, Int32 axis, Int32 axis1, Int32 logical, Int32 mode);
        /******************Single axis follow stopping setting function**********************
        Function:Set the IN synchronization action
        Parameter:
		        axisactive axis
		        axis1driven axis1
		        logicalLevel signal|0:From high to low 
				             |1:From low to high
                        modeactive axis stop?|0:yes
		                              1|:no
        Return         0:correct          1:wrong
        Note:Signal changes detected, driven axis has stopped and the driving status of active axis can be set
        **********************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_in_stop2(Int32 cardno, Int32 axis, Int32 axis1,Int32 axis2, Int32 logical, Int32 mode);
        /*******************2-axis follow stopping setting function**********************
        Function:Set the IN synchronization action
        Parameter:
		        axisactive axis
		        axis1driven axis1
		        axis2driven axis2
		        logicalLevel signal|0:From high to low 
				             |1:From low to high
                        modeactive axis stop?|0:yes
		                              1|:no
        Return         0:correct          1:wrong
        Note:Signal changes detected, driven axis has stopped and the driving status of active axis can be set
        *********************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_in_stop3(Int32 cardno, Int32 axis, Int32 logical, Int32 mode);
        /**************************3-axis follow stopping setting function********************
        Function:Set the IN synchronization action
        Parameter:
		        axisactive axis		
		        logicalLevel signal|0:From high to low 
				             |1:From low to high
                        modeactive axis stop?|0:yes
		                              1|:no
        Return         0:correct          1:wrong
        Note:Signal changes detected, driven axis has stopped and the driving status of active axis can be set
        *********************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_comp_pmove1(Int32 cardno, Int32 axis, Int32 axis1, Int32  pulse, Int32  pulse1, Int32 regi, Int32 term);
        /******Setting of single-axis drive when arriving at the target position****************
        Function:Setting of single-axis drive when arriving at the target position
        Parameter:
		        axisactive axis
		        axis1driven axis
		        pulseActive axis pulses
		        pulse1drive pulse of driven axis1
                        regi0|comp+  Select the compare register		
                              1|comp-
                        term0|>=  Select the compare register 		    
                              1|< 
        Return         0:correct          1:wrong
        **********************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_comp_pmove2(Int32 cardno, Int32 axis, Int32 axis1,Int32 axis2, Int32  pulse, Int32  pulse1,Int32  pulse2, Int32 regi, Int32 term);
        /************Setting of 2-axis drive when arriving at the target position***************
        Function:Setting of 2-axis drive when arriving at the target position
        Parameter:
		        axisactive axis
		        axis1driven axis1
		        axis2driven axis2
		        pulsetarget position of active axis
		        pulse1drive pulse of driven axis1
		        pulse2drive pulse of driven axis2
		        regi0|comp+  Select the compare register		
                              1|comp-
                        term0|>=  Select the compare register 		    
                              1|< 
        Return         0:correct          1:wrong
        **********************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_comp_pmove3(Int32 cardno, Int32 axis, Int32 axis1,Int32 axis2, Int32 axis3, Int32  pulse, Int32  pulse1,Int32  pulse2,Int32  pulse3, Int32 regi, Int32 term);
        /************Setting of 3-axis drive when arriving at the target position***************
        Function:Setting of 3-axis drive when arriving at the target position
        Parameter:
		        axisactive axis
		        axis1driven axis1
		        axis2driven axis2
		        axis2driven axis3
		        pulsetarget position of active axis
		        pulse1drive pulse of driven axis1
		        pulse2drive pulse of driven axis2
		        pulse3drive pulse of driven axis3
		        regi0|comp+  Select the compare register		
                              1|comp-
                        term0|>=  Select the compare register 		    
                              1|<   
        Return         0:correct          1:wrong
        **********************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_comp_stop1(Int32 cardno,Int32 axis,Int32 axis1,Int32  pulse,Int32 regi,Int32 term,Int32 mode);
        /************Setting of stopping drive when arriving at the target position***********
        Function:Setting of stopping drive when arriving at the target position
        Parameter:
		        axisactive axis
		        axis1driven axis1		
		        pulsetarget position of active axis	
		        regi0|comp+  Select the compare register		
                              1|comp-
                        term0|>=  Select the compare register 		    
                              1|< 
                        modeactive axis stop?|0:yes
		                              1|:no
        		                      
        Return         0:correct          1:wrong
        ***********************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_comp_stop2(Int32 cardno,Int32 axis,Int32 axis1,Int32 axis2,Int32  pulse,Int32 regi,Int32 term,Int32 mode);
        /*********Setting of stopping drive when arriving at the target position**************
        Function:Setting of stopping drive when arriving at the target position
        Parameter:
		        axisactive axis
		        axis1driven axis1	
		        axis2driven axis2
		        pulsetarget position of active axis	
		        regi0|comp+  Select the compare register		
                              1|comp-
                        term0|>=  Select the compare register 		    
                              1|< 
                        modeactive axis stop?|0:yes
		                              1|:no
        Return         0:correct          1:wrong
        ***********************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_set_comp_stop3(Int32 cardno,Int32 axis,Int32  pulse,Int32 regi,Int32 term,Int32 mode);
        /**************Setting of stopping drive when arriving at the target position************
        Function:Setting of stopping drive when arriving at the target position
        Parameter:
		        axisactive axis		
		        pulsetarget position of active axis	
		        regi0|comp+  Select the compare register		
                              1|comp-
                        term0|>=  Select the compare register 		    
                              1|< 
                        modeactive axis stop?|0:yes
		                              1|:no	
        Return         0:correct          1:wrong
        ***********************************************************************/

        //--------------------------------------------------------------------------//
        //                      Composite drives                                    //
        //Note:The following functions are added for the convenience of customers   //
        //--------------------------------------------------------------------------//
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_symmetry_relative_move(Int32 cardno, Int32 axis, Int32  pulse, Int32  lspd ,Int32  hspd, double tacc, Int32  vacc, Int32 mode);
        /*************Symmetrical relative movement of single-axis*************************
        Function: Refer to the current position and perform quantitative movement in the symmetrical acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis---axis number
	          pulse--pulse
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        **********************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_symmetry_absolute_move(Int32 cardno, Int32 axis, Int32  pulse, Int32  lspd ,Int32  hspd, double tacc, Int32  vacc, Int32 mode);
        /****************Symmetrical absolute movement of single-axis*************************
        Function:Refer to the position of zero poInt32 and perform quantitative movement in the symmetrical acceleration/deceleration
        Parameter:
                  cardno-card number 
	          axis---axis number
	          pulse--pulse
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ********************************************************************/


        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_unsymmetry_relative_move(Int32 cardno, Int32 axis, Int32  pulse, Int32  lspd ,Int32  hspd, double tacc, double tdec, Int32  vacc, Int32 mode);
        /**************asymmetrical relative movement of single-axis************************
        Function:Refer to the current position and perform quantitative movement in the asymmetrical acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis---axis number
	          pulse--pulse
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          tdec---time of deceleration (Unit: sec)
	          vacc---change rate of acceleration/deceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        *********************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_unsymmetry_absolute_move(Int32 cardno, Int32 axis, Int32  pulse, Int32  lspd ,Int32  hspd, double tacc, double tdec, Int32  vacc, Int32 mode);
        /******************asymmetrical absolute movement of single-axis**************************
        Function:Refer to the position of zero poInt32 and perform quantitative movement in the asymmetrical acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis---axis number
	          pulse--pulse
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          tdec---time of deceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ********************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_symmetry_relative_line2(Int32 cardno, Int32 axis1, Int32 axis2, Int32  pulse1, Int32  pulse2, Int32  lspd ,Int32  hspd, double tacc, Int32  vacc, Int32 mode);
        /***************Relative movement of two-axis symmetrical linear Int32erpolation**************
        Function:Refer to current position and perform linear Int32erpolation in symmetrical acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          pulse1--pulse1
	          pulse2--pulse2
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/

        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_symmetry_absolute_line2(Int32 cardno, Int32 axis1, Int32 axis2, Int32  pulse1, Int32  pulse2, Int32  lspd ,Int32  hspd, double tacc, Int32  vacc, Int32 mode);
        /************Two axes symmetric linear Int32erpolation absolute moving**********************
        Function:Refer to the position of zero poInt32 and perform linear Int32erpolation in symmetrical acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          pulse1--pulse1
	          pulse2--pulse2
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/


        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_unsymmetry_relative_line2(Int32 cardno, Int32 axis1, Int32 axis2, Int32  pulse1, Int32  pulse2, Int32  lspd ,Int32  hspd, double tacc, double tdec, Int32  vacc, Int32 mode);
        /**************Two axes asymmetric linear Int32erpolation relative moving********************
        Function:Refer to current position and perform linear Int32erpolation in asymmetric acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          pulse1--pulse1
	          pulse2--pulse2
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          tdec---time of deceleration (Unit: sec)
	          vacc---change rate of acceleration/deceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_unsymmetry_absolute_line2(Int32 cardno, Int32 axis1, Int32 axis2, Int32  pulse1, Int32  pulse2, Int32  lspd ,Int32  hspd, double tacc, double tdec, Int32  vacc, Int32 mode);
        /***************Two axes asymmetric linear Int32erpolation absolute moving***************
        Function:Refer to the position of zero poInt32 and perform linear Int32erpolation in asymmetric acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          pulse1--pulse1
	          pulse2--pulse2
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          tdec---time of deceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_symmetry_relative_line3(Int32 cardno, Int32 axis1, Int32 axis2, Int32 axis3, Int32  pulse1, Int32  pulse2, Int32  pulse3, Int32  lspd ,Int32  hspd, double tacc, Int32  vacc, Int32 mode);
        /******************Three axes symmetric linear Int32erpolation relative moving*************
        Function:Refer to current position and perform linear Int32erpolation in symmetric acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          axis3---axis number3	
	          pulse1--pulse1
	          pulse2--pulse2
	          pulse3--pulse3
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_symmetry_absolute_line3(Int32 cardno, Int32 axis1, Int32 axis2, Int32 axis3, Int32  pulse1, Int32  pulse2, Int32  pulse3, Int32  lspd ,Int32  hspd, double tacc, Int32  vacc, Int32 mode);
        /*********************Three axes symmetric linear Int32erpolation absolute moving************
        Function:Refer to the position of zero poInt32 and perform linear Int32erpolation in symmetric acceleration/deceleration.
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          axis3---axis number3
	          pulse1--pulse1
	          pulse2--pulse2
	          pulse3--pulse3
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_unsymmetry_relative_line3(Int32 cardno, Int32 axis1, Int32 axis2, Int32 axis3, Int32  pulse1, Int32  pulse2, Int32  pulse3, Int32  lspd ,Int32  hspd, double tacc, double tdec, Int32  vacc, Int32 mode);
        /****************Three axes asymmetric linear Int32erpolation relative moving***********
        Function:Refer to current position and perform linear Int32erpolation in asymmetric acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          axis3---axis number3	
	          pulse1--pulse1
	          pulse2--pulse2
	          pulse3--pulse3
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          tdec---time of deceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/


        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_unsymmetry_absolute_line3(Int32 cardno, Int32 axis1, Int32 axis2, Int32 axis3, Int32  pulse1, Int32  pulse2, Int32  pulse3, Int32  lspd ,Int32  hspd, double tacc, double tdec, Int32  vacc, Int32 mode);
        /*****************Three axes asymmetric linear Int32erpolation absolute moving************
        Function:Refer to the position of zero poInt32 and perform linear Int32erpolation in asymmetric acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          axis3---axis number3
	          pulse1--pulse1
	          pulse2--pulse2
	          pulse3--pulse3
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          tdec---time of deceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_symmetry_relative_arc(Int32 cardno, Int32 axis1, Int32 axis2, Int32  x, Int32  y, Int32  i, Int32  j, Int32 dir, Int32  lspd ,Int32  hspd, double tacc, Int32  vacc, Int32 mode);
        /*****************Two axes symmetric arc Int32erpolation relative moving*******************
        Function:Refer to current position and perform arc Int32erpolation in symmetric acceleration/deceleration.
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          xy----Coordinates of arc end poInt32 (Refer to current poInt32, that is, starting poInt32 of arc)
	          ij----Centre coordinate (Refer to current poInt32, that is, starting poInt32 of arc)
	          dir-----Moving direction (0-Clockwise,1-Anti-clockwise)
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_symmetry_absolute_arc(Int32 cardno, Int32 axis1, Int32 axis2, Int32  x, Int32  y, Int32  i, Int32  j, Int32 dir, Int32  lspd ,Int32  hspd, double tacc, Int32  vacc, Int32 mode);
        /***************Two axes symmetric arc Int32erpolation absolute moving********************
        Function:Refer to the position of zero poInt32 and perform arc Int32erpolation in symmetric acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          xy----Coordinates of arc end poInt32 (Refer to current poInt32, that is, starting poInt32 of arc)
	          ij----Centre coordinate (Refer to current poInt32, that is, starting poInt32 of arc)
	          dir-----Moving direction (0-Clockwise,1-Anti-clockwise)
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/


        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_unsymmetry_relative_arc(Int32 cardno, Int32 axis1, Int32 axis2, Int32  x, Int32  y, Int32  i, Int32  j, Int32 dir, Int32  lspd ,Int32  hspd, double tacc, double tdec, Int32  vacc, Int32 mode);
        /*******************Two axes asymmetric arc Int32erpolation relative moving*************
        Function: Refer to current position and perform arc Int32erpolation in asymmetric acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          xy----Coordinates of arc end poInt32 (Refer to current poInt32, that is, starting poInt32 of arc)
	          ij----Centre coordinate (Refer to current poInt32, that is, starting poInt32 of arc)
	          dir-----Moving direction (0-Clockwise,1-Anti-clockwise)
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          tdec---time of deceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_unsymmetry_absolute_arc(Int32 cardno, Int32 axis1, Int32 axis2, Int32  x, Int32  y, Int32  i, Int32  j, Int32 dir, Int32  lspd ,Int32  hspd, double tacc, double tdec, Int32  vacc, Int32 mode);
        /*********************Two axes asymmetric arc Int32erpolation absolute moving*******************
        Function:Refer to position of zero poInt32 and perform arc Int32erpolation in asymmetric acceleration/deceleration
        Parameter:
                  cardno-card number
	          axis1---axis number1
	          axis2---axis number2	
	          xy----Coordinates of arc end poInt32 (Refer to current poInt32, that is, starting poInt32 of arc)
	          ij----Centre coordinate (Refer to current poInt32, that is, starting poInt32 of arc)
	          dir-----Moving direction (0-Clockwise,1-Anti-clockwise)
	          lspd---low speed
	          hspd---high speed
                  tacc---time of acceleration (Unit: sec)
	          tdec---time of deceleration (Unit: sec)
	          vacc---change rate of acceleration
	          mode---mode (trapezoid(0) or S-curve(1))
        Return         0:correct          1:wrong
        ******************************************************************/

        //----------------------------------------------------//
        //                Switch quantity input/output        //
        //----------------------------------------------------//
        
        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_read_bit(Int32 cardno,Int32 number);
        /*************************Read single input bit**************************
        Function:Get the status of single input bit
        Parameter:
	        cardno	   card number
	        number	   Input bit (0-34)
        Return	       0:low level		   1:high level		   -1:wrong
        ******************************************************************/

        [DllImport("adt8948m.dll")]
        public static extern Int32 adt8948_write_bit(Int32 cardno,Int32 number,Int32 value);
        /*****************************Output single bit****************************
        Function:Corresponding port performs output operation.
        Parameter:
	        cardno	   card number
	        number	   Output bit(0-31)
	        value	   0:low		 1:high
        Return	       0:correct 				1:wrong
        ******************************************************************/
    }
}
